/*
 * Decompiled with CFR 0.152.
 */
package processing.video;

import java.io.File;
import java.nio.ByteOrder;
import java.nio.file.Paths;
import java.util.List;
import org.freedesktop.gstreamer.Gst;
import org.freedesktop.gstreamer.Plugin;
import org.freedesktop.gstreamer.Registry;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.video.Environment;
import processing.video.LibraryLoader;

public class Video
implements PConstants {
    public static int DEBUG_LEVEL = 1;
    public static String gstreamerLibPath = "";
    public static String gstreamerPluginPath = "";
    protected static boolean usingGStreamerSystemInstall = false;
    protected static boolean useGLBufferSink = true;
    protected static boolean defaultGLibContext = false;
    protected static long INSTANCES_COUNT = 0L;
    protected static int bitsJVM = PApplet.parseInt((String)System.getProperty("sun.arch.data.model"));

    protected static void init() {
        if (INSTANCES_COUNT == 0L) {
            Video.initImpl();
        }
        ++INSTANCES_COUNT;
    }

    protected static void restart() {
        Video.removePlugins();
        Gst.deinit();
        Video.initImpl();
    }

    protected static void initImpl() {
        File file;
        Object object;
        String string = System.getProperty("gstreamer.library.path");
        int n = 0;
        if (string != null) {
            gstreamerLibPath = string;
            object = System.getProperty("gstreamer.plugin.path");
            if (object != null) {
                gstreamerPluginPath = object;
            }
            usingGStreamerSystemInstall = false;
        } else {
            object = "";
            if (bitsJVM == 64) {
                if (System.getenv("GSTREAMER_1_0_ROOT_X86_64") != null) {
                    n = 0;
                    object = System.getenv("GSTREAMER_1_0_ROOT_X86_64");
                } else if (System.getenv("GSTREAMER_1_0_ROOT_MINGW_X86_64") != null) {
                    n = 1;
                    object = System.getenv("GSTREAMER_1_0_ROOT_MINGW_X86_64");
                } else if (System.getenv("GSTREAMER_1_0_ROOT_MSVC_X86_64") != null) {
                    n = 2;
                    object = System.getenv("GSTREAMER_1_0_ROOT_MSVC_X86_64");
                }
            }
            if (!object.equals("")) {
                gstreamerLibPath = PApplet.platform == 2 ? Paths.get((String)object, "lib").toString() : Paths.get((String)object, "bin").toString();
                file = new File(gstreamerLibPath);
                if (file.exists()) {
                    usingGStreamerSystemInstall = true;
                    Video.buildSystemPaths((String)object);
                } else {
                    gstreamerLibPath = "";
                }
            }
        }
        if (string == null && !usingGStreamerSystemInstall && Video.buildBundldedPaths()) {
            n = 2;
        }
        if (gstreamerLibPath.equals("")) {
            object = "";
            if (PApplet.platform == 2) {
                object = "/Library/Frameworks/GStreamer.framework/Versions/1.0";
                gstreamerLibPath = Paths.get((String)object, "lib").toString();
            } else if (PApplet.platform == 1) {
                if (bitsJVM == 64) {
                    if (new File("C:\\gstreamer\\1.0\\x86_64").exists()) {
                        n = 0;
                        object = "C:\\gstreamer\\1.0\\x86_64";
                    } else if (new File("C:\\gstreamer\\1.0\\mingw_x86_64").exists()) {
                        n = 1;
                        object = "C:\\gstreamer\\1.0\\mingw_x86_64";
                    } else if (new File("C:\\gstreamer\\1.0\\msvc_x86_64").exists()) {
                        n = 2;
                        object = "C:\\gstreamer\\1.0\\msvc_x86_64";
                    }
                    gstreamerLibPath = Paths.get((String)object, "bin").toString();
                }
            } else if (PApplet.platform == 3 && (file = new File((String)(object = bitsJVM == 64 ? "/lib/x86_64-linux-gnu" : "/lib/x86-linux-gnu"), "libgstreamer-1.0.so.0")).exists()) {
                gstreamerLibPath = Paths.get((String)object, new String[0]).toString();
            }
            file = new File(gstreamerLibPath);
            if (file.exists()) {
                if (bitsJVM == 64) {
                    if (n == 0) {
                        Environment.libc.setenv("GSTREAMER_1_0_ROOT_X86_64", gstreamerLibPath, true);
                    } else if (n == 1) {
                        Environment.libc.setenv("GSTREAMER_1_0_ROOT_MINGW_X86_64", gstreamerLibPath, true);
                    } else if (n == 2) {
                        Environment.libc.setenv("GSTREAMER_1_0_ROOT_MSVC_X86_64", gstreamerLibPath, true);
                    }
                }
                Video.buildSystemPaths((String)object);
            } else {
                System.err.println("We could not find a system-wide or bundled installation of GStreamer, but video might still work if GStreamer was placed somewhere else");
            }
            usingGStreamerSystemInstall = true;
        }
        if (!gstreamerLibPath.equals("")) {
            System.setProperty("jna.library.path", gstreamerLibPath);
        }
        Environment.libc.setenv("GST_DEBUG", String.valueOf(DEBUG_LEVEL), true);
        if (!usingGStreamerSystemInstall) {
            Environment.libc.setenv("GST_REGISTRY_FORK", "no", true);
            if (!gstreamerPluginPath.equals("")) {
                Environment.libc.setenv("GST_PLUGIN_SYSTEM_PATH_1_0", "", true);
            }
        }
        if ((PApplet.platform == 1 || !usingGStreamerSystemInstall && PApplet.platform == 3) && (object = LibraryLoader.getInstance(n)) == null) {
            System.err.println("Cannot load GStreamer libraries.");
        }
        object = new String[]{""};
        Gst.setUseDefaultContext((boolean)defaultGLibContext);
        Gst.init((String)"Processing core video", (String[])object);
        Video.printGStreamerInfo();
        if (!usingGStreamerSystemInstall) {
            Video.scanPlugins();
        }
    }

    protected static void printGStreamerInfo() {
        String string = "";
        string = usingGStreamerSystemInstall ? "system-wide" : "bundled";
        System.out.println("Processing video library using " + string + " GStreamer " + Gst.getVersion());
    }

    protected static void scanPlugins() {
        if (!gstreamerPluginPath.equals("")) {
            Registry registry = Registry.get();
            System.out.print("Scanning GStreamer plugins...");
            boolean bl = registry.scanPath(gstreamerPluginPath);
            if (bl) {
                System.out.println(" Done.");
            } else {
                System.err.println("Cannot load GStreamer plugins from " + gstreamerPluginPath);
            }
        }
    }

    protected static void removePlugins() {
        Registry registry = Registry.get();
        List list = registry.getPluginList();
        for (Plugin plugin : list) {
            registry.removePlugin(plugin);
        }
    }

    private static String searchLibraryPath(String string) {
        String string2 = System.getProperty("java.library.path");
        if (string2 != null) {
            String[] stringArray;
            for (String string3 : stringArray = PApplet.split((String)string2, (char)File.pathSeparatorChar)) {
                File file;
                if (string3.startsWith("/lib/") || string3.startsWith("/usr/lib/") || !(file = new File(string3, string)).exists()) continue;
                return file.getAbsolutePath();
            }
        }
        return null;
    }

    private static String searchClassPath(String string) {
        String string2 = System.getProperty("java.class.path");
        if (string2 != null) {
            String[] stringArray;
            for (String string3 : stringArray = PApplet.split((String)string2, (char)File.pathSeparatorChar)) {
                File file;
                File file2 = new File(string3);
                if (file2.isFile()) {
                    file2 = file2.getParentFile();
                }
                if (!(file = new File(file2, string)).exists()) continue;
                return file.getAbsolutePath();
            }
        }
        return null;
    }

    protected static void buildSystemPaths(String string) {
        gstreamerPluginPath = System.getenv("GST_PLUGIN_SYSTEM_PATH") != null ? System.getenv("GST_PLUGIN_SYSTEM_PATH") : (PApplet.platform == 1 ? Paths.get(string, "lib", "gstreamer-1.0").toString() : Paths.get(gstreamerLibPath, "gstreamer-1.0").toString());
        File file = new File(gstreamerPluginPath);
        if (!file.exists()) {
            gstreamerPluginPath = "";
        }
    }

    protected static boolean buildBundldedPaths() {
        gstreamerPluginPath = Video.searchLibraryPath("gstreamer-1.0");
        if (gstreamerPluginPath == null) {
            gstreamerPluginPath = Video.searchClassPath("gstreamer-1.0");
        }
        if (gstreamerPluginPath == null) {
            gstreamerPluginPath = "";
            gstreamerLibPath = "";
            usingGStreamerSystemInstall = true;
            return false;
        }
        File file = new File(gstreamerPluginPath).getParentFile();
        gstreamerLibPath = file.getAbsolutePath();
        return true;
    }

    protected static float nanoSecToSecFrac(long l) {
        return (float)((double)l / 1.0E9);
    }

    protected static long secToNanoLong(float f) {
        Double d = (double)f * 1.0E9;
        return d.longValue();
    }

    protected static void convertToARGB(int[] nArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        if (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN) {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    int n5 = nArray[n4++];
                    nArray[n3++] = n5 >>> 8 | n5 << 24 & 0xFF000000;
                }
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    int n6 = nArray[n4++];
                    nArray[n3++] = (n6 & 0xFF) << 16 | (n6 & 0xFF0000) >> 16 | n6 & 0xFF00FF00;
                }
            }
        }
    }
}

