/*
 * Decompiled with CFR 0.152.
 */
package processing.video;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.freedesktop.gstreamer.Buffer;
import org.freedesktop.gstreamer.Bus;
import org.freedesktop.gstreamer.Caps;
import org.freedesktop.gstreamer.Element;
import org.freedesktop.gstreamer.FlowReturn;
import org.freedesktop.gstreamer.Format;
import org.freedesktop.gstreamer.Fraction;
import org.freedesktop.gstreamer.Gst;
import org.freedesktop.gstreamer.GstObject;
import org.freedesktop.gstreamer.Sample;
import org.freedesktop.gstreamer.State;
import org.freedesktop.gstreamer.Structure;
import org.freedesktop.gstreamer.elements.AppSink;
import org.freedesktop.gstreamer.elements.PlayBin;
import org.freedesktop.gstreamer.event.SeekFlags;
import org.freedesktop.gstreamer.event.SeekType;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.video.Video;

public class Movie
extends PImage
implements PConstants {
    public static String[] supportedProtocols = new String[]{"http", "https"};
    public String filename;
    public PlayBin playbin;
    public int sourceWidth;
    public int sourceHeight;
    public float sourceFrameRate;
    public float frameRate;
    protected float rate;
    protected float volume;
    protected boolean playing = false;
    protected boolean paused = false;
    protected boolean repeat = false;
    protected Method movieEventMethod;
    protected Object eventHandler;
    protected boolean available;
    protected boolean ready;
    protected boolean newFrame;
    protected AppSink rgbSink = null;
    protected int[] copyPixels = null;
    protected boolean firstFrame = true;
    protected boolean useBufferSink = false;
    protected boolean outdatedPixels = true;
    protected Object bufferSink;
    protected Method sinkCopyMethod;
    protected Method sinkSetMethod;
    protected Method sinkDisposeMethod;
    protected Method sinkGetMethod;
    private NewSampleListener newSampleListener;
    private NewPrerollListener newPrerollListener;
    private final Lock bufferLock = new ReentrantLock();

    public Movie(PApplet pApplet, String string) {
        super(0, 0, 2);
        this.initGStreamer(pApplet, string);
    }

    public void dispose() {
        if (this.playbin != null) {
            try {
                if (this.playbin.isPlaying()) {
                    this.playbin.stop();
                    this.playbin.getState();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.pixels = null;
            this.rgbSink.disconnect((AppSink.NEW_SAMPLE)this.newSampleListener);
            this.rgbSink.disconnect((AppSink.NEW_PREROLL)this.newPrerollListener);
            this.rgbSink.dispose();
            this.playbin.setState(State.NULL);
            this.playbin.getState();
            this.playbin.getBus().dispose();
            this.playbin.dispose();
            this.parent.g.removeCache((PImage)this);
            this.parent.unregisterMethod("dispose", (Object)this);
            this.parent.unregisterMethod("post", (Object)this);
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    public void frameRate(float f) {
        long l;
        long l2;
        float f2 = 0.0f < f && 0.0f < this.frameRate ? f / this.frameRate : 1.0f;
        long l3 = this.playbin.queryPosition(TimeUnit.NANOSECONDS);
        if (this.rate > 0.0f) {
            l2 = l3;
            l = -1L;
        } else {
            l2 = 0L;
            l = l3;
        }
        this.seek(this.rate * f2, l2, l);
        this.frameRate = f;
    }

    public void speed(float f) {
        if ((double)PApplet.abs((float)(this.rate - f)) > 0.1) {
            this.rate = f;
            this.frameRate(this.frameRate);
        }
    }

    public float duration() {
        long l = this.playbin.queryDuration(TimeUnit.NANOSECONDS);
        return Video.nanoSecToSecFrac(l);
    }

    public float time() {
        long l = this.playbin.queryPosition(TimeUnit.NANOSECONDS);
        return Video.nanoSecToSecFrac(l);
    }

    public void jump(float f) {
        this.setReady();
        if (this.sourceFrameRate != -1.0f) {
            int n = (int)(f * this.sourceFrameRate);
            f = (float)n / this.sourceFrameRate;
        }
        long l = Video.secToNanoLong(f);
        this.seek(this.rate, l, -1L);
    }

    public boolean available() {
        return this.available;
    }

    public void play() {
        this.setReady();
        this.playbin.play();
        this.playbin.getState();
        this.playing = true;
        this.paused = false;
    }

    public void loop() {
        this.repeat = true;
        this.play();
    }

    public void noLoop() {
        this.setReady();
        this.repeat = false;
    }

    public void pause() {
        this.setReady();
        this.playbin.pause();
        this.playbin.getState();
        this.playing = false;
        this.paused = true;
    }

    public void stop() {
        this.setReady();
        this.playbin.stop();
        this.playbin.getState();
        this.playing = false;
        this.paused = false;
    }

    public synchronized void read() {
        if (this.firstFrame) {
            super.init(this.sourceWidth, this.sourceHeight, 2, 1);
            this.firstFrame = false;
        }
        if (this.useBufferSink) {
            Object object;
            if (this.bufferSink == null && (object = this.parent.g.getCache((PImage)this)) != null) {
                this.setBufferSink(object);
                this.getSinkMethods();
            }
        } else {
            int[] nArray = this.pixels;
            this.pixels = this.copyPixels;
            this.updatePixels();
            this.copyPixels = nArray;
        }
        this.available = false;
        this.newFrame = true;
    }

    public void volume(float f) {
        if (this.playing && PApplet.abs((float)(this.volume - f)) > 0.001f) {
            this.playbin.setVolume((double)f);
            this.playbin.getState();
            this.volume = f;
        }
    }

    public synchronized void loadPixels() {
        super.loadPixels();
        if (this.useBufferSink && this.bufferSink != null) {
            try {
                this.sinkGetMethod.invoke(this.bufferSink, new Object[]{this.pixels});
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.outdatedPixels = false;
        }
    }

    public int get(int n, int n2) {
        if (this.outdatedPixels) {
            this.loadPixels();
        }
        return super.get(n, n2);
    }

    public PImage get(int n, int n2, int n3, int n4) {
        if (this.outdatedPixels) {
            this.loadPixels();
        }
        return super.get(n, n2, n3, n4);
    }

    public PImage copy() {
        if (this.outdatedPixels) {
            this.loadPixels();
        }
        return super.copy();
    }

    protected void getImpl(int n, int n2, int n3, int n4, PImage pImage, int n5, int n6) {
        if (this.outdatedPixels) {
            this.loadPixels();
        }
        super.getImpl(n, n2, n3, n4, pImage, n5, n6);
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean isLooping() {
        return this.repeat;
    }

    protected void initGStreamer(PApplet pApplet, String string) {
        block15: {
            this.parent = pApplet;
            Video.init();
            this.playbin = null;
            try {
                File file;
                try {
                    file = new File(pApplet.dataPath(string));
                    if (file.exists()) {
                        this.playbin = new PlayBin("Movie Player");
                        this.playbin.setInputFile(file);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (this.playbin == null) {
                    try {
                        file = new File(string);
                        if (file.exists()) {
                            this.playbin = new PlayBin("Movie Player");
                            this.playbin.setInputFile(file);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                if (this.playbin != null) break block15;
                for (int i = 0; i < supportedProtocols.length; ++i) {
                    if (!string.startsWith(supportedProtocols[i] + "://")) continue;
                    try {
                        this.playbin = new PlayBin("Movie Player");
                        this.playbin.setURI(URI.create(string));
                        break;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (this.playbin == null) {
            pApplet.die("Could not load movie file " + string, null);
        }
        this.initSink();
        this.playbin.setVideoSink((Element)this.rgbSink);
        this.makeBusConnections(this.playbin.getBus());
        try {
            this.filename = string;
            pApplet.registerMethod("dispose", (Object)this);
            pApplet.registerMethod("post", (Object)this);
            this.setEventHandlerObject(pApplet);
            this.sourceHeight = 0;
            this.sourceWidth = 0;
            this.sourceFrameRate = -1.0f;
            this.frameRate = -1.0f;
            this.rate = 1.0f;
            this.volume = -1.0f;
            this.ready = false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void setEventHandlerObject(Object object) {
        this.eventHandler = object;
        try {
            this.movieEventMethod = this.eventHandler.getClass().getMethod("movieEvent", Movie.class);
            return;
        }
        catch (Exception exception) {
            try {
                this.movieEventMethod = this.eventHandler.getClass().getMethod("movieEvent", Object.class);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return;
        }
    }

    protected void initSink() {
        this.rgbSink = new AppSink("movie sink");
        this.rgbSink.set("emit-signals", (Object)true);
        this.newSampleListener = new NewSampleListener();
        this.newPrerollListener = new NewPrerollListener();
        this.rgbSink.connect((AppSink.NEW_SAMPLE)this.newSampleListener);
        this.rgbSink.connect((AppSink.NEW_PREROLL)this.newPrerollListener);
        boolean bl = this.useBufferSink = Video.useGLBufferSink && this.parent.g.isGL();
        if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
            if (this.useBufferSink) {
                this.rgbSink.setCaps(Caps.fromString((String)"video/x-raw, format=RGBA"));
            } else {
                this.rgbSink.setCaps(Caps.fromString((String)"video/x-raw, format=BGRA"));
            }
        } else {
            this.rgbSink.setCaps(Caps.fromString((String)"video/x-raw, format=ARGB"));
        }
    }

    protected void setReady() {
        if (!this.ready) {
            this.playbin.setState(State.READY);
            this.newFrame = false;
            this.ready = true;
        }
    }

    private void makeBusConnections(Bus bus) {
        bus.connect(new Bus.ERROR(){

            public void errorMessage(GstObject gstObject, int n, String string) {
                System.err.println(gstObject + " : " + string);
            }
        });
        bus.connect(new Bus.EOS(){

            public void endOfStream(GstObject gstObject) {
                if (Movie.this.repeat) {
                    if (0.0f < Movie.this.rate) {
                        Movie.this.jump(0.0f);
                    } else {
                        Movie.this.jump(Movie.this.duration());
                    }
                    Movie.this.frameRate(Movie.this.frameRate);
                } else {
                    Movie.this.playing = false;
                }
            }
        });
    }

    private void seek(final double d, final long l, final long l2) {
        Gst.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                boolean bl = l2 == -1L ? Movie.this.playbin.seek(d, Format.TIME, EnumSet.of(SeekFlags.FLUSH, SeekFlags.ACCURATE), SeekType.SET, l, SeekType.NONE, l2) : Movie.this.playbin.seek(d, Format.TIME, EnumSet.of(SeekFlags.FLUSH, SeekFlags.ACCURATE), SeekType.SET, l, SeekType.SET, l2);
                if (!bl) {
                    PGraphics.showWarning((String)"Seek operation failed.");
                }
            }
        });
    }

    private void fireMovieEvent() {
        if (this.movieEventMethod != null) {
            try {
                this.movieEventMethod.invoke(this.eventHandler, new Object[]{this});
            }
            catch (Exception exception) {
                System.err.println("error, disabling movieEvent() for " + this.filename);
                exception.printStackTrace();
                this.movieEventMethod = null;
            }
        }
    }

    public void setBufferSink(Object object) {
        this.bufferSink = object;
    }

    public boolean hasBufferSink() {
        return this.bufferSink != null;
    }

    public synchronized void disposeBuffer(Object object) {
        ((Buffer)object).dispose();
    }

    protected void getSinkMethods() {
        try {
            this.sinkCopyMethod = this.bufferSink.getClass().getMethod("copyBufferFromSource", Object.class, ByteBuffer.class, Integer.TYPE, Integer.TYPE);
        }
        catch (Exception exception) {
            throw new RuntimeException("Movie: provided sink object doesn't have a copyBufferFromSource method.");
        }
        try {
            this.sinkSetMethod = this.bufferSink.getClass().getMethod("setBufferSource", Object.class);
            this.sinkSetMethod.invoke(this.bufferSink, new Object[]{this});
        }
        catch (Exception exception) {
            throw new RuntimeException("Movie: provided sink object doesn't have a setBufferSource method.");
        }
        try {
            this.sinkDisposeMethod = this.bufferSink.getClass().getMethod("disposeSourceBuffer", new Class[0]);
        }
        catch (Exception exception) {
            throw new RuntimeException("Movie: provided sink object doesn't have a disposeSourceBuffer method.");
        }
        try {
            this.sinkGetMethod = this.bufferSink.getClass().getMethod("getBufferPixels", int[].class);
        }
        catch (Exception exception) {
            throw new RuntimeException("Movie: provided sink object doesn't have a getBufferPixels method.");
        }
    }

    public synchronized void post() {
        if (this.useBufferSink && this.sinkDisposeMethod != null) {
            try {
                this.sinkDisposeMethod.invoke(this.bufferSink, new Object[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    static /* synthetic */ Lock access$200(Movie movie) {
        return movie.bufferLock;
    }

    static /* synthetic */ void access$300(Movie movie) {
        movie.fireMovieEvent();
    }

    private class NewSampleListener
    implements AppSink.NEW_SAMPLE {
        private NewSampleListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public FlowReturn newSample(AppSink var1_1) {
            var2_2 = var1_1.pullSample();
            var3_3 = var2_2.getCaps().getStructure(0);
            Movie.this.sourceWidth = var3_3.getInteger("width");
            Movie.this.sourceHeight = var3_3.getInteger("height");
            var4_4 = var3_3.getFraction("framerate");
            Movie.this.sourceFrameRate = (float)var4_4.numerator / (float)var4_4.denominator;
            if ((double)Movie.this.frameRate == -1.0) {
                Movie.this.frameRate = Movie.this.sourceFrameRate;
            }
            if ((var6_6 = (var5_5 = var2_2.getBuffer()).map(false)) != null) {
                if (!Movie.access$200(Movie.this).tryLock()) {
                    return FlowReturn.OK;
                }
                Movie.this.available = true;
                if (Movie.this.useBufferSink && Movie.this.bufferSink != null) {
                    try {
                        Movie.this.sinkCopyMethod.invoke(Movie.this.bufferSink, new Object[]{var5_5, var6_6, Movie.this.sourceWidth, Movie.this.sourceHeight});
                        if (!Movie.this.playing) ** GOTO lbl38
                        Movie.access$300(Movie.this);
                    }
                    catch (Exception var7_7) {
                        var7_7.printStackTrace();
                    }
                    finally {
                        Movie.access$200(Movie.this).unlock();
                    }
                } else {
                    var7_8 = var6_6.asIntBuffer();
                    if (Movie.this.copyPixels == null) {
                        Movie.this.copyPixels = new int[Movie.this.sourceWidth * Movie.this.sourceHeight];
                    }
                    try {
                        var7_8.get(Movie.this.copyPixels, 0, Movie.this.width * Movie.this.height);
                        if (Movie.this.playing) {
                            Movie.access$300(Movie.this);
                        }
                    }
                    finally {
                        Movie.access$200(Movie.this).unlock();
                    }
                }
                var5_5.unmap();
            }
            var2_2.dispose();
            return FlowReturn.OK;
        }
    }

    private class NewPrerollListener
    implements AppSink.NEW_PREROLL {
        private NewPrerollListener() {
        }

        public FlowReturn newPreroll(AppSink appSink) {
            Sample sample = appSink.pullPreroll();
            Structure structure = sample.getCaps().getStructure(0);
            Movie.this.sourceWidth = structure.getInteger("width");
            Movie.this.sourceHeight = structure.getInteger("height");
            Fraction fraction = structure.getFraction("framerate");
            Movie.this.sourceFrameRate = (float)fraction.numerator / (float)fraction.denominator;
            if ((double)Movie.this.frameRate == -1.0) {
                Movie.this.frameRate = Movie.this.sourceFrameRate;
            }
            sample.dispose();
            return FlowReturn.OK;
        }
    }
}

