/*
 * Decompiled with CFR 0.152.
 */
package processing.video;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.util.HashMap;
import java.util.Map;

public class LibraryLoader {
    private static LibraryLoader instance;
    static final Object[][] WINDOWS_MINGW_DEPENDENCIES;
    static final Object[][] WINDOWS_MSVC_DEPENDENCIES;
    static final Object[][] LINUX_DEPENDENCIES;
    static Object[][] dependencies;
    private static final Map<String, Object> loadedMap;
    private static final int RECURSIVE_LOAD_MAX_DEPTH = 5;

    private LibraryLoader() {
    }

    private void preLoadLibs(int n) {
        if (Platform.isWindows()) {
            if (n == 0) {
                System.err.println("Seems like you are trying to use GStreamer native libraries older than 1.20, which are not supported.");
                return;
            }
            if (n == 1) {
                dependencies = WINDOWS_MINGW_DEPENDENCIES;
            } else if (n == 2) {
                dependencies = WINDOWS_MSVC_DEPENDENCIES;
            }
        } else if (Platform.isLinux()) {
            dependencies = LINUX_DEPENDENCIES;
        } else {
            return;
        }
        for (Object[] objectArray : dependencies) {
            this.load(objectArray[0].toString(), DummyLibrary.class, true, 0, (Boolean)objectArray[2]);
        }
    }

    private static String[] findDeps(String string) {
        for (Object[] objectArray : dependencies) {
            if (!string.equals(objectArray[0])) continue;
            return (String[])objectArray[1];
        }
        return new String[0];
    }

    public Object load(String string, Class<?> clazz, boolean bl) {
        return this.load(string, clazz, true, 0, bl);
    }

    private Object load(String string, Class<?> clazz, boolean bl, int n, boolean bl2) {
        assert (n < 5) : String.format("recursive max load depth %s has been exceeded", n);
        Object object = loadedMap.get(string);
        if (null == object || bl) {
            try {
                String[] stringArray;
                for (String string2 : stringArray = LibraryLoader.findDeps(string)) {
                    this.load(string2, DummyLibrary.class, false, n + 1, bl2);
                }
                object = LibraryLoader.loadLibrary(string, clazz, bl2);
                if (object != null) {
                    loadedMap.put(string, object);
                }
            }
            catch (Exception exception) {
                if (bl2) {
                    throw new RuntimeException(String.format("can not load required library %s", string, exception));
                }
                System.out.println(String.format("can not load library %s", string, exception));
            }
        }
        return object;
    }

    private static Object loadLibrary(String string, Class<?> clazz, boolean bl) {
        String[] stringArray;
        if (Platform.isWindows()) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "lib%s";
            stringArray2[1] = "lib%s-0";
            stringArray = stringArray2;
            stringArray2[2] = "%s";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "%s-0";
            stringArray = stringArray3;
            stringArray3[1] = "%s";
        }
        String[] stringArray4 = stringArray;
        UnsatisfiedLinkError unsatisfiedLinkError = null;
        for (String string2 : stringArray4) {
            try {
                String string3 = String.format(string2, string);
                Object object = Native.loadLibrary((String)string3, clazz);
                return object;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                unsatisfiedLinkError = unsatisfiedLinkError2;
            }
        }
        if (bl) {
            throw new UnsatisfiedLinkError(String.format("can't load library %s (%1$s|lib%1$s|lib%1$s-0) with -Djna.library.path=%s. Last error:%s", string, System.getProperty("jna.library.path"), unsatisfiedLinkError));
        }
        System.out.println(String.format("can't load library %s (%1$s|lib%1$s|lib%1$s-0) with -Djna.library.path=%s. Last error:%s", string, System.getProperty("jna.library.path"), unsatisfiedLinkError));
        return null;
    }

    public static synchronized LibraryLoader getInstance(int n) {
        if (null == instance) {
            instance = new LibraryLoader();
            instance.preLoadLibs(n);
        }
        return instance;
    }

    static {
        WINDOWS_MINGW_DEPENDENCIES = new Object[][]{{"avcodec-58", new String[0], false}, {"avfilter-7", new String[0], false}, {"avformat-58", new String[0], false}, {"avutil-56", new String[0], false}, {"libass-9", new String[0], false}, {"libbz2", new String[0], false}, {"libcairo-2", new String[0], false}, {"libcairo-gobject-2", new String[0], false}, {"libcairo-script-interpreter-2", new String[0], false}, {"libcharset-1", new String[0], false}, {"libcroco-0.6-3", new String[0], false}, {"libcrypto-1_1-x64", new String[0], false}, {"libdca-0", new String[0], false}, {"libdv-4", new String[0], false}, {"libexpat-1", new String[0], false}, {"libffi-7", new String[0], false}, {"libFLAC-8", new String[0], false}, {"libfontconfig-1", new String[0], false}, {"libfreetype-6", new String[0], false}, {"libfribidi-0", new String[0], false}, {"libgcc_s_seh-1", new String[0], false}, {"libgdk_pixbuf-2.0-0", new String[0], false}, {"libges-1.0-0", new String[0], false}, {"libgio-2.0-0", new String[0], false}, {"libglib-2.0-0", new String[0], false}, {"libgmodule-2.0-0", new String[0], false}, {"libgobject-2.0-0", new String[0], false}, {"libgraphene-1.0-0", new String[0], false}, {"libgstadaptivedemux-1.0-0", new String[0], false}, {"libgstallocators-1.0-0", new String[0], false}, {"libgstapp-1.0-0", new String[0], false}, {"libgstaudio-1.0-0", new String[0], false}, {"libgstbadaudio-1.0-0", new String[0], false}, {"libgstbase-1.0-0", new String[0], false}, {"libgstbasecamerabinsrc-1.0-0", new String[0], false}, {"libgstcheck-1.0-0", new String[0], false}, {"libgstcodecparsers-1.0-0", new String[0], false}, {"libgstcodecs-1.0-0", new String[0], false}, {"libgstcontroller-1.0-0", new String[0], false}, {"libgstd3d11-1.0-0", new String[0], false}, {"libgstfft-1.0-0", new String[0], false}, {"libgstgl-1.0-0", new String[0], false}, {"libgstinsertbin-1.0-0", new String[0], false}, {"libgstisoff-1.0-0", new String[0], false}, {"libgstmpegts-1.0-0", new String[0], false}, {"libgstnet-1.0-0", new String[0], false}, {"libgstpbutils-1.0-0", new String[0], false}, {"libgstphotography-1.0-0", new String[0], false}, {"libgstplay-1.0-0", new String[0], false}, {"libgstplayer-1.0-0", new String[0], false}, {"libgstreamer-1.0-0", new String[0], false}, {"libgstriff-1.0-0", new String[0], false}, {"libgstrtp-1.0-0", new String[0], false}, {"libgstrtsp-1.0-0", new String[0], false}, {"libgstrtspserver-1.0-0", new String[0], false}, {"libgstsctp-1.0-0", new String[0], false}, {"libgstsdp-1.0-0", new String[0], false}, {"libgsttag-1.0-0", new String[0], false}, {"libgsttranscoder-1.0-0", new String[0], false}, {"libgsturidownloader-1.0-0", new String[0], false}, {"libgstvalidate-1.0-0", new String[0], false}, {"libgstvideo-1.0-0", new String[0], false}, {"libgstwebrtc-1.0-0", new String[0], false}, {"libgthread-2.0-0", new String[0], false}, {"libharfbuzz-0", new String[0], false}, {"libiconv-2", new String[0], false}, {"libintl-8", new String[0], false}, {"libjpeg-8", new String[0], false}, {"libjson-glib-1.0-0", new String[0], false}, {"libkate-1", new String[0], false}, {"libmp3lame-0", new String[0], false}, {"libmpg123-0", new String[0], false}, {"libnice-10", new String[0], false}, {"libogg-0", new String[0], false}, {"liboggkate-1", new String[0], false}, {"libopencore-amrnb-0", new String[0], false}, {"libopencore-amrwb-0", new String[0], false}, {"libopenh264-6", new String[0], false}, {"libopenjp2", new String[0], false}, {"libopus-0", new String[0], false}, {"liborc-0.4-0", new String[0], false}, {"liborc-test-0.4-0", new String[0], false}, {"libpango-1.0-0", new String[0], false}, {"libpangocairo-1.0-0", new String[0], false}, {"libpangoft2-1.0-0", new String[0], false}, {"libpangowin32-1.0-0", new String[0], false}, {"libpixman-1-0", new String[0], false}, {"libpng16-16", new String[0], false}, {"libpsl-5", new String[0], false}, {"librsvg-2-2", new String[0], false}, {"librtmp-1", new String[0], false}, {"libsbc-1", new String[0], false}, {"libSoundTouch-1", new String[0], false}, {"libsoup-2.4-1", new String[0], false}, {"libspandsp-2", new String[0], false}, {"libspeex-1", new String[0], false}, {"libsqlite3-0", new String[0], false}, {"libsrt", new String[0], false}, {"libsrtp2-1", new String[0], false}, {"libssl-1_1-x64", new String[0], false}, {"libstdc++-6", new String[0], false}, {"libtag", new String[0], false}, {"libtheora-0", new String[0], false}, {"libtheoradec-1", new String[0], false}, {"libtheoraenc-1", new String[0], false}, {"libtiff-5", new String[0], false}, {"libturbojpeg-0", new String[0], false}, {"libvo-aacenc-0", new String[0], false}, {"libvorbis-0", new String[0], false}, {"libvorbisenc-2", new String[0], false}, {"libvorbisfile-3", new String[0], false}, {"libwavpack", new String[0], false}, {"libwebrtc_audio_processing-0", new String[0], false}, {"libwinpthread-1", new String[0], false}, {"libx264-157", new String[0], false}, {"libxml2-2", new String[0], false}, {"libz-1", new String[0], false}, {"libzbar-0", new String[0], false}, {"swresample-3", new String[0], false}};
        WINDOWS_MSVC_DEPENDENCIES = new Object[][]{{"avcodec-58", new String[0], false}, {"avfilter-7", new String[0], false}, {"avformat-58", new String[0], false}, {"avutil-56", new String[0], false}, {"bz2", new String[0], false}, {"cairo-2", new String[0], false}, {"cairo-gobject-2", new String[0], false}, {"cairo-script-interpreter-2", new String[0], false}, {"dv-4", new String[0], false}, {"ffi-7", new String[0], false}, {"fontconfig-1", new String[0], false}, {"fribidi-0", new String[0], false}, {"gdk_pixbuf-2.0-0", new String[0], false}, {"ges-1.0-0", new String[0], false}, {"gio-2.0-0", new String[0], false}, {"glib-2.0-0", new String[0], false}, {"gmodule-2.0-0", new String[0], false}, {"gobject-2.0-0", new String[0], false}, {"graphene-1.0-0", new String[0], false}, {"gstadaptivedemux-1.0-0", new String[0], false}, {"gstallocators-1.0-0", new String[0], false}, {"gstapp-1.0-0", new String[0], false}, {"gstaudio-1.0-0", new String[0], false}, {"gstbadaudio-1.0-0", new String[0], false}, {"gstbase-1.0-0", new String[0], false}, {"gstbasecamerabinsrc-1.0-0", new String[0], false}, {"gstcheck-1.0-0", new String[0], false}, {"gstcodecparsers-1.0-0", new String[0], false}, {"gstcodecs-1.0-0", new String[0], false}, {"gstcontroller-1.0-0", new String[0], false}, {"gstd3d11-1.0-0", new String[0], false}, {"gstfft-1.0-0", new String[0], false}, {"gstgl-1.0-0", new String[0], false}, {"gstinsertbin-1.0-0", new String[0], false}, {"gstisoff-1.0-0", new String[0], false}, {"gstmpegts-1.0-0", new String[0], false}, {"gstnet-1.0-0", new String[0], false}, {"gstpbutils-1.0-0", new String[0], false}, {"gstphotography-1.0-0", new String[0], false}, {"gstplay-1.0-0", new String[0], false}, {"gstplayer-1.0-0", new String[0], false}, {"gstreamer-1.0-0", new String[0], false}, {"gstriff-1.0-0", new String[0], false}, {"gstrtp-1.0-0", new String[0], false}, {"gstrtsp-1.0-0", new String[0], false}, {"gstrtspserver-1.0-0", new String[0], false}, {"gstsctp-1.0-0", new String[0], false}, {"gstsdp-1.0-0", new String[0], false}, {"gsttag-1.0-0", new String[0], false}, {"gsttranscoder-1.0-0", new String[0], false}, {"gsturidownloader-1.0-0", new String[0], false}, {"gstvalidate-1.0-0", new String[0], false}, {"gstvideo-1.0-0", new String[0], false}, {"gstwebrtc-1.0-0", new String[0], false}, {"gstwinrt-1.0-0", new String[0], false}, {"gthread-2.0-0", new String[0], false}, {"harfbuzz", new String[0], false}, {"intl-8", new String[0], false}, {"json-glib-1.0-0", new String[0], false}, {"libass-9", new String[0], false}, {"libcharset-1", new String[0], false}, {"libcroco-0.6-3", new String[0], false}, {"libcrypto-1_1-x64", new String[0], false}, {"libdca-0", new String[0], false}, {"libexpat-1", new String[0], false}, {"libFLAC-8", new String[0], false}, {"libfreetype-6", new String[0], false}, {"libgcc_s_seh-1", new String[0], false}, {"libiconv-2", new String[0], false}, {"libjpeg-8", new String[0], false}, {"libkate-1", new String[0], false}, {"libmp3lame-0", new String[0], false}, {"libmpg123-0", new String[0], false}, {"libogg-0", new String[0], false}, {"liboggkate-1", new String[0], false}, {"libopencore-amrnb-0", new String[0], false}, {"libopencore-amrwb-0", new String[0], false}, {"libpng16-16", new String[0], false}, {"librsvg-2-2", new String[0], false}, {"librtmp-1", new String[0], false}, {"libsbc-1", new String[0], false}, {"libspandsp-2", new String[0], false}, {"libspeex-1", new String[0], false}, {"libsrt", new String[0], false}, {"libssl-1_1-x64", new String[0], false}, {"libstdc++-6", new String[0], false}, {"libtheora-0", new String[0], false}, {"libtheoradec-1", new String[0], false}, {"libtheoraenc-1", new String[0], false}, {"libtiff-5", new String[0], false}, {"libturbojpeg-0", new String[0], false}, {"libvo-aacenc-0", new String[0], false}, {"libvorbis-0", new String[0], false}, {"libvorbisenc-2", new String[0], false}, {"libvorbisfile-3", new String[0], false}, {"libwinpthread-1", new String[0], false}, {"libx264-157", new String[0], false}, {"libxml2-2", new String[0], false}, {"libzbar-0", new String[0], false}, {"nice-10", new String[0], false}, {"openh264-6", new String[0], false}, {"openjp2", new String[0], false}, {"opus-0", new String[0], false}, {"orc-0.4-0", new String[0], false}, {"orc-test-0.4-0", new String[0], false}, {"pango-1.0-0", new String[0], false}, {"pangocairo-1.0-0", new String[0], false}, {"pangoft2-1.0-0", new String[0], false}, {"pangowin32-1.0-0", new String[0], false}, {"pixman-1-0", new String[0], false}, {"psl-5", new String[0], false}, {"soup-2.4-1", new String[0], false}, {"sqlite3-0", new String[0], false}, {"srtp2-1", new String[0], false}, {"swresample-3", new String[0], false}, {"wavpack", new String[0], false}, {"z-1", new String[0], false}};
        LINUX_DEPENDENCIES = new Object[][]{{"glib-2.0", new String[0], false}, {"gobject-2.0", new String[0], false}, {"gio-2.0", new String[0], false}, {"gmodule-2.0", new String[0], false}, {"gthread-2.0", new String[0], false}, {"gstreamer-1.0", new String[0], false}, {"gstbase-1.0", new String[0], false}, {"gsturidownloader-1.0", new String[0], false}, {"gstadaptivedemux-1.0", new String[0], false}, {"gstapp-1.0", new String[0], false}, {"gsttag-1.0", new String[0], false}, {"gstvideo-1.0", new String[0], false}, {"gstaudio-1.0", new String[0], false}, {"gstpbutils-1.0", new String[0], false}, {"gstplay-1.0", new String[0], false}, {"gstplayer-1.0", new String[0], false}, {"gstbadaudio-1.0", new String[0], false}, {"gstbasecamerabinsrc-1.0", new String[0], false}, {"gstcheck-1.0", new String[0], false}, {"gstcodecparsers-1.0", new String[0], false}, {"gstcontroller-1.0", new String[0], false}, {"gstfft-1.0", new String[0], false}, {"gstinsertbin-1.0", new String[0], false}, {"gstisoff-1.0", new String[0], false}, {"gstmpegts-1.0", new String[0], false}, {"gstnet-1.0", new String[0], false}, {"gstphotography-1.0", new String[0], false}, {"gstallocators-1.0", new String[0], false}, {"libgstcodecs-1.0", new String[0], false}, {"gstriff-1.0", new String[0], false}, {"gstrtp-1.0", new String[0], false}, {"gstrtsp-1.0", new String[0], false}, {"gstsdp-1.0", new String[0], false}, {"gstsctp-1.0", new String[0], false}, {"gstrtspserver-1.0", new String[0], false}, {"gstvalidate-1.0", new String[0], false}, {"gstvalidate-default-overrides-1.0", new String[0], false}, {"gstwebrtc-1.0", new String[0], false}, {"gsttranscoder-1.0", new String[0], false}, {"xml2", new String[0], false}, {"avutil", new String[0], false}, {"swresample", new String[0], false}, {"swscale", new String[0], false}, {"avcodec", new String[0], false}, {"avformat", new String[0], false}, {"avresample", new String[0], false}, {"avfilter", new String[0], false}, {"avdevice", new String[0], false}, {"avtp", new String[0], false}, {"cairo-gobject", new String[0], false}, {"cairo-script-interpreter", new String[0], false}, {"cairo", new String[0], false}, {"dv", new String[0], false}, {"fdk_aac", new String[0], false}, {"fontconfig", new String[0], false}, {"freetype", new String[0], false}, {"fribidi", new String[0], false}, {"ges-1.0", new String[0], false}, {"harfbuzz-gobject", new String[0], false}, {"harfbuzz", new String[0], false}, {"harfbuzz-subset", new String[0], false}, {"jpeg", new String[0], false}, {"json-glib-1.0", new String[0], false}, {"microdns", new String[0], false}, {"mp3lame", new String[0], false}, {"nice", new String[0], false}, {"ogg", new String[0], false}, {"openh264", new String[0], false}, {"openjp2", new String[0], false}, {"opus", new String[0], false}, {"orc-0.4", new String[0], false}, {"orc-test-0.4", new String[0], false}, {"pango-1.0", new String[0], false}, {"pangoft2-1.0", new String[0], false}, {"pixman-1", new String[0], false}, {"png16", new String[0], false}, {"postproc", new String[0], false}, {"psl", new String[0], false}, {"soup-2.4", new String[0], false}, {"soup-gnome-2.4", new String[0], false}, {"sqlite3", new String[0], false}, {"vorbisenc", new String[0], false}, {"vorbisfile", new String[0], false}, {"vorbis", new String[0], false}};
        loadedMap = new HashMap<String, Object>();
    }

    public static interface DummyLibrary
    extends Library {
    }
}

