/*
 * Decompiled with CFR 0.152.
 */
package processing.video;

import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.freedesktop.gstreamer.Buffer;
import org.freedesktop.gstreamer.Bus;
import org.freedesktop.gstreamer.Caps;
import org.freedesktop.gstreamer.Element;
import org.freedesktop.gstreamer.ElementFactory;
import org.freedesktop.gstreamer.FlowReturn;
import org.freedesktop.gstreamer.Format;
import org.freedesktop.gstreamer.Fraction;
import org.freedesktop.gstreamer.Gst;
import org.freedesktop.gstreamer.GstObject;
import org.freedesktop.gstreamer.Pipeline;
import org.freedesktop.gstreamer.Sample;
import org.freedesktop.gstreamer.State;
import org.freedesktop.gstreamer.Structure;
import org.freedesktop.gstreamer.device.Device;
import org.freedesktop.gstreamer.device.DeviceMonitor;
import org.freedesktop.gstreamer.elements.AppSink;
import org.freedesktop.gstreamer.event.SeekFlags;
import org.freedesktop.gstreamer.event.SeekType;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.video.Video;

public class Capture
extends PImage
implements PConstants {
    public Pipeline pipeline;
    public int sourceWidth;
    public int sourceHeight;
    public float sourceFrameRate;
    public float frameRate;
    protected float rate;
    protected boolean capturing = false;
    protected Method captureEventMethod;
    protected Object eventHandler;
    protected boolean available;
    protected boolean ready;
    protected boolean newFrame;
    protected AppSink rgbSink = null;
    protected int[] copyPixels = null;
    protected boolean firstFrame = true;
    protected boolean useBufferSink = false;
    protected boolean outdatedPixels = true;
    protected Object bufferSink;
    protected Method sinkCopyMethod;
    protected Method sinkSetMethod;
    protected Method sinkDisposeMethod;
    protected Method sinkGetMethod;
    protected String device;
    protected static List<Device> devices;
    NewSampleListener newSampleListener;
    NewPrerollListener newPrerollListener;
    private final Lock bufferLock = new ReentrantLock();

    public Capture(PApplet pApplet) {
        this(pApplet, 640, 480, null, 30.0f);
    }

    public Capture(PApplet pApplet, String string) {
        this(pApplet, 640, 480, string, 30.0f);
    }

    public Capture(PApplet pApplet, int n, int n2) {
        this(pApplet, n, n2, null, 30.0f);
    }

    public Capture(PApplet pApplet, int n, int n2, float f) {
        this(pApplet, n, n2, null, f);
    }

    public Capture(PApplet pApplet, int n, int n2, String string) {
        this(pApplet, n, n2, string, 30.0f);
    }

    public Capture(PApplet pApplet, String string, float f) {
        this(pApplet, 640, 480, string, f);
    }

    public Capture(PApplet pApplet, int n, int n2, String string, float f) {
        super(n, n2, 1);
        this.device = string;
        this.frameRate = f;
        this.initGStreamer(pApplet);
    }

    public void dispose() {
        if (this.pipeline != null) {
            try {
                if (this.pipeline.isPlaying()) {
                    this.pipeline.stop();
                    this.pipeline.getState();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.pixels = null;
            if (this.rgbSink != null) {
                this.rgbSink.disconnect((AppSink.NEW_SAMPLE)this.newSampleListener);
                this.rgbSink.disconnect((AppSink.NEW_PREROLL)this.newPrerollListener);
                this.rgbSink.dispose();
            }
            this.pipeline.setState(State.NULL);
            this.pipeline.getState();
            this.pipeline.getBus().dispose();
            this.pipeline.dispose();
            this.parent.g.removeCache((PImage)this);
            this.parent.unregisterMethod("dispose", (Object)this);
            this.parent.unregisterMethod("post", (Object)this);
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }

    public void frameRate(float f) {
        long l;
        long l2;
        float f2 = 0.0f < f && 0.0f < this.frameRate ? f / this.frameRate : 1.0f;
        long l3 = this.pipeline.queryPosition(TimeUnit.NANOSECONDS);
        if (this.rate > 0.0f) {
            l2 = l3;
            l = -1L;
        } else {
            l2 = 0L;
            l = l3;
        }
        this.seek(this.rate * f2, l2, l);
        this.frameRate = f;
    }

    public boolean available() {
        return this.available;
    }

    public void start() {
        this.setReady();
        this.pipeline.play();
        this.pipeline.getState();
        this.capturing = true;
    }

    public void stop() {
        this.setReady();
        this.pipeline.stop();
        this.pipeline.getState();
        this.capturing = false;
    }

    public synchronized void read() {
        if (this.firstFrame) {
            super.init(this.sourceWidth, this.sourceHeight, 1, 1);
            this.firstFrame = false;
        }
        if (this.useBufferSink) {
            Object object;
            if (this.bufferSink == null && (object = this.parent.g.getCache((PImage)this)) != null) {
                this.setBufferSink(object);
                this.getSinkMethods();
            }
        } else {
            int[] nArray = this.pixels;
            this.pixels = this.copyPixels;
            this.updatePixels();
            this.copyPixels = nArray;
        }
        this.available = false;
        this.newFrame = true;
    }

    public synchronized void loadPixels() {
        super.loadPixels();
        if (this.useBufferSink && this.bufferSink != null) {
            try {
                this.sinkGetMethod.invoke(this.bufferSink, new Object[]{this.pixels});
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.outdatedPixels = false;
        }
    }

    public int get(int n, int n2) {
        if (this.outdatedPixels) {
            this.loadPixels();
        }
        return super.get(n, n2);
    }

    public PImage get(int n, int n2, int n3, int n4) {
        if (this.outdatedPixels) {
            this.loadPixels();
        }
        return super.get(n, n2, n3, n4);
    }

    public PImage copy() {
        if (this.outdatedPixels) {
            this.loadPixels();
        }
        return super.copy();
    }

    protected void getImpl(int n, int n2, int n3, int n4, PImage pImage, int n5, int n6) {
        if (this.outdatedPixels) {
            this.loadPixels();
        }
        super.getImpl(n, n2, n3, n4, pImage, n5, n6);
    }

    public boolean isCapturing() {
        return this.capturing;
    }

    protected void initGStreamer(PApplet pApplet) {
        this.parent = pApplet;
        this.pipeline = null;
        Video.init();
        if (this.device == null) {
            String[] stringArray = Capture.list();
            if (stringArray != null && stringArray.length > 0) {
                this.device = stringArray[0];
            } else {
                throw new IllegalStateException("Could not find any devices");
            }
        }
        this.device = this.device.trim();
        int n = this.device.indexOf("pipeline:");
        if (n == 0) {
            this.initCustomPipeline(this.device.substring(9));
        } else {
            this.initDevicePipeline();
        }
        try {
            pApplet.registerMethod("dispose", (Object)this);
            pApplet.registerMethod("post", (Object)this);
            this.setEventHandlerObject(pApplet);
            this.sourceHeight = 0;
            this.sourceWidth = 0;
            this.sourceFrameRate = -1.0f;
            this.frameRate = -1.0f;
            this.rate = 1.0f;
            this.ready = false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static String fpsToFramerate(float f) {
        String string = Float.toString(f);
        int n = string.indexOf(46);
        if (Math.floor(f) != (double)f) {
            int n2 = (int)Math.pow(10.0, string.length() - n - 1);
            int n3 = (int)(f * (float)n2);
            return n3 + "/" + n2;
        }
        return (int)f + "/1";
    }

    protected void initCustomPipeline(String string) {
        String string2 = " ! videorate ! videoscale ! videoconvert ! appsink name=sink";
        this.pipeline = (Pipeline)Gst.parseLaunch((String)(string + string2));
        String string3 = ", width=" + this.width + ", height=" + this.height;
        if ((double)this.frameRate != 0.0) {
            string3 = string3 + ", framerate=" + Capture.fpsToFramerate(this.frameRate);
        }
        this.rgbSink = (AppSink)this.pipeline.getElementByName("sink");
        this.rgbSink.set("emit-signals", (Object)true);
        this.newSampleListener = new NewSampleListener();
        this.newPrerollListener = new NewPrerollListener();
        this.rgbSink.connect((AppSink.NEW_SAMPLE)this.newSampleListener);
        this.rgbSink.connect((AppSink.NEW_PREROLL)this.newPrerollListener);
        boolean bl = this.useBufferSink = Video.useGLBufferSink && this.parent.g.isGL();
        if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
            if (this.useBufferSink) {
                this.rgbSink.setCaps(Caps.fromString((String)("video/x-raw, format=RGBx" + string3)));
            } else {
                this.rgbSink.setCaps(Caps.fromString((String)("video/x-raw, format=BGRx" + string3)));
            }
        } else {
            this.rgbSink.setCaps(Caps.fromString((String)("video/x-raw, format=xRGB" + string3)));
        }
        this.makeBusConnections(this.pipeline.getBus());
    }

    protected void initDevicePipeline() {
        String string;
        Element element = null;
        if (this.device == null) {
            element = ElementFactory.make((String)"autovideosrc", null);
        } else {
            if (devices == null) {
                DeviceMonitor deviceMonitor = new DeviceMonitor();
                deviceMonitor.addFilter("Video/Source", null);
                devices = deviceMonitor.getDevices();
                deviceMonitor.close();
            }
            for (int i = 0; i < devices.size(); ++i) {
                string = Capture.assignDisplayName(devices.get(i), i);
                if (!devices.get(i).getDisplayName().equals(this.device) && !devices.get(i).getName().equals(this.device) && !string.equals(this.device)) continue;
                element = devices.get(i).createElement(null);
                break;
            }
            if (element == null) {
                throw new RuntimeException("Could not find device " + this.device);
            }
        }
        this.pipeline = new Pipeline();
        Element element2 = ElementFactory.make((String)"videoscale", null);
        string = ElementFactory.make((String)"videoconvert", null);
        Element element3 = ElementFactory.make((String)"capsfilter", null);
        if ((double)this.frameRate == 0.0) {
            System.err.println("The capture framerate cannot be zero!");
            return;
        }
        String string2 = ", framerate=" + Capture.fpsToFramerate(this.frameRate);
        element3.set("caps", (Object)Caps.fromString((String)("video/x-raw, width=" + this.width + ", height=" + this.height + string2)));
        this.initSink();
        this.pipeline.add(element);
        this.pipeline.add(element2);
        this.pipeline.add((Element)string);
        this.pipeline.add(element3);
        this.pipeline.add((Element)this.rgbSink);
        element.link(element2);
        element2.link((Element)string);
        string.link(element3);
        element3.link((Element)this.rgbSink);
        this.makeBusConnections(this.pipeline.getBus());
    }

    protected void setEventHandlerObject(Object object) {
        this.eventHandler = object;
        try {
            this.captureEventMethod = this.eventHandler.getClass().getMethod("captureEvent", Capture.class);
            return;
        }
        catch (Exception exception) {
            try {
                this.captureEventMethod = this.eventHandler.getClass().getMethod("captureEvent", Object.class);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return;
        }
    }

    protected void initSink() {
        this.rgbSink = new AppSink("capture sink");
        this.rgbSink.set("emit-signals", (Object)true);
        this.newSampleListener = new NewSampleListener();
        this.newPrerollListener = new NewPrerollListener();
        this.rgbSink.connect((AppSink.NEW_SAMPLE)this.newSampleListener);
        this.rgbSink.connect((AppSink.NEW_PREROLL)this.newPrerollListener);
        boolean bl = this.useBufferSink = Video.useGLBufferSink && this.parent.g.isGL();
        if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
            if (this.useBufferSink) {
                this.rgbSink.setCaps(Caps.fromString((String)"video/x-raw, format=RGBx"));
            } else {
                this.rgbSink.setCaps(Caps.fromString((String)"video/x-raw, format=BGRx"));
            }
        } else {
            this.rgbSink.setCaps(Caps.fromString((String)"video/x-raw, format=xRGB"));
        }
    }

    protected void setReady() {
        if (!this.ready) {
            this.pipeline.setState(State.READY);
            this.newFrame = false;
            this.ready = true;
        }
    }

    private void makeBusConnections(Bus bus) {
        bus.connect(new Bus.ERROR(){

            public void errorMessage(GstObject gstObject, int n, String string) {
                System.err.println(gstObject + " : " + string);
            }
        });
        bus.connect(new Bus.EOS(){

            public void endOfStream(GstObject gstObject) {
                try {
                    Capture.this.stop();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    private void seek(final double d, final long l, final long l2) {
        Gst.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                boolean bl = Capture.this.pipeline.seek(d, Format.TIME, EnumSet.of(SeekFlags.FLUSH, SeekFlags.ACCURATE), SeekType.SET, l, SeekType.SET, l2);
                if (!bl) {
                    PGraphics.showWarning((String)"Seek operation failed.");
                }
            }
        });
    }

    private void fireCaptureEvent() {
        if (this.captureEventMethod != null) {
            try {
                this.captureEventMethod.invoke(this.eventHandler, new Object[]{this});
            }
            catch (Exception exception) {
                System.err.println("error, disabling captureEvent()");
                exception.printStackTrace();
                this.captureEventMethod = null;
            }
        }
    }

    public void setBufferSink(Object object) {
        this.bufferSink = object;
    }

    public boolean hasBufferSink() {
        return this.bufferSink != null;
    }

    public synchronized void disposeBuffer(Object object) {
        ((Buffer)object).dispose();
    }

    protected void getSinkMethods() {
        try {
            this.sinkCopyMethod = this.bufferSink.getClass().getMethod("copyBufferFromSource", Object.class, ByteBuffer.class, Integer.TYPE, Integer.TYPE);
        }
        catch (Exception exception) {
            throw new RuntimeException("Capture: provided sink object doesn't have a copyBufferFromSource method.");
        }
        try {
            this.sinkSetMethod = this.bufferSink.getClass().getMethod("setBufferSource", Object.class);
            this.sinkSetMethod.invoke(this.bufferSink, new Object[]{this});
        }
        catch (Exception exception) {
            throw new RuntimeException("Capture: provided sink object doesn't have a setBufferSource method.");
        }
        try {
            this.sinkDisposeMethod = this.bufferSink.getClass().getMethod("disposeSourceBuffer", new Class[0]);
        }
        catch (Exception exception) {
            throw new RuntimeException("Capture: provided sink object doesn't have a disposeSourceBuffer method.");
        }
        try {
            this.sinkGetMethod = this.bufferSink.getClass().getMethod("getBufferPixels", int[].class);
        }
        catch (Exception exception) {
            throw new RuntimeException("Capture: provided sink object doesn't have a getBufferPixels method.");
        }
    }

    public synchronized void post() {
        if (this.useBufferSink && this.sinkDisposeMethod != null) {
            try {
                this.sinkDisposeMethod.invoke(this.bufferSink, new Object[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static String[] list() {
        Video.init();
        DeviceMonitor deviceMonitor = new DeviceMonitor();
        deviceMonitor.addFilter("Video/Source", null);
        devices = deviceMonitor.getDevices();
        deviceMonitor.close();
        String[] stringArray = new String[devices.size()];
        for (int i = 0; i < devices.size(); ++i) {
            Device device = devices.get(i);
            stringArray[i] = Capture.checkCameraDuplicates(device) > 1 ? Capture.assignDisplayName(device, i) : device.getDisplayName();
        }
        return stringArray;
    }

    public static String[] getCapabilities(String string) {
        for (int i = 0; i < devices.size(); ++i) {
            String string2 = Capture.assignDisplayName(devices.get(i), i);
            if (!devices.get(i).getDisplayName().equals(string) && !devices.get(i).getName().equals(string) && !string2.equals(string)) continue;
            return Capture.parseCaps(devices.get(i));
        }
        return new String[0];
    }

    private static String[] parseCaps(Device device) {
        String[] stringArray = device.getCaps().toString().split(";");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            if (string.indexOf("video/x-raw,") == -1) continue;
            int n = string.indexOf("width");
            int n2 = string.indexOf("height");
            int n3 = string.indexOf("framerate");
            String string2 = "";
            String string3 = "";
            String string4 = "";
            if (0 < n && 0 < n2 && 0 < n3) {
                string2 = string.substring(n, string.indexOf(44, n));
                string3 = string.substring(n2, string.indexOf(", format", n2));
                string4 = string.substring(n3, string.indexOf(93, n3));
            }
            if (0 < string3.indexOf("{")) {
                String[] stringArray2;
                string3 = string3.substring(13, string3.length() - 1);
                for (String string5 : stringArray2 = string3.split(",")) {
                    string3 = "height=(int)" + string5.trim();
                    Capture.addCapStringsToList(string2, string3, string4, arrayList);
                }
                continue;
            }
            Capture.addCapStringsToList(string2, string3, string4, arrayList);
        }
        String[] stringArray3 = new String[]{};
        return arrayList.toArray(stringArray3);
    }

    private static void addCapStringsToList(String string, String string2, String string3, ArrayList<String> arrayList) {
        String[] stringArray;
        if (0 < string.split("=").length) {
            string = string.substring(11);
            try {
                Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                string2 = "";
            }
        }
        if (0 < string2.split("=").length) {
            string2 = string2.substring(12);
            try {
                Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                string2 = "";
            }
        }
        if (0 < string3.split("=,").length && 1 < (stringArray = (string3 = string3.substring(string3.indexOf("="))).split(",")).length && (stringArray = (string3 = stringArray[1].trim()).split("/")).length == 2) {
            try {
                int n = Integer.parseInt(stringArray[0]);
                int n2 = Integer.parseInt(stringArray[1]);
                int n3 = n / n2;
                string3 = String.valueOf(n3);
            }
            catch (NumberFormatException numberFormatException) {
                string3 = "";
            }
        }
        if (!(string.equals("") || string2.equals("") || string3.equals(""))) {
            arrayList.add("size=" + string + "x" + string2 + ",fps=" + string3);
        }
    }

    private static String assignDisplayName(Device device, int n) {
        String string = "";
        int n2 = 1;
        for (int i = 0; i < devices.size(); ++i) {
            if (!devices.get(i).getDisplayName().equals(device.getDisplayName())) continue;
            if (i == n) {
                string = device.getDisplayName() + " #" + Integer.toString(n2);
            }
            ++n2;
        }
        return string;
    }

    private static int checkCameraDuplicates(Device device) {
        int n = 0;
        for (int i = 0; i < devices.size(); ++i) {
            if (!devices.get(i).getDisplayName().equals(device.getDisplayName())) continue;
            ++n;
        }
        return n;
    }

    static /* synthetic */ Lock access$200(Capture capture) {
        return capture.bufferLock;
    }

    static /* synthetic */ void access$300(Capture capture) {
        capture.fireCaptureEvent();
    }

    private class NewSampleListener
    implements AppSink.NEW_SAMPLE {
        private NewSampleListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public FlowReturn newSample(AppSink var1_1) {
            var2_2 = var1_1.pullSample();
            var3_3 = var2_2.getCaps().getStructure(0);
            Capture.this.sourceWidth = var3_3.getInteger("width");
            Capture.this.sourceHeight = var3_3.getInteger("height");
            var4_4 = var3_3.getFraction("framerate");
            Capture.this.sourceFrameRate = (float)var4_4.numerator / (float)var4_4.denominator;
            if ((double)Capture.this.frameRate == -1.0) {
                Capture.this.frameRate = Capture.this.sourceFrameRate;
            }
            if ((var6_6 = (var5_5 = var2_2.getBuffer()).map(false)) != null) {
                if (!Capture.access$200(Capture.this).tryLock()) {
                    return FlowReturn.OK;
                }
                Capture.this.available = true;
                if (Capture.this.useBufferSink && Capture.this.bufferSink != null) {
                    try {
                        Capture.this.sinkCopyMethod.invoke(Capture.this.bufferSink, new Object[]{var5_5, var6_6, Capture.this.sourceWidth, Capture.this.sourceHeight});
                        if (!Capture.this.capturing) ** GOTO lbl38
                        Capture.access$300(Capture.this);
                    }
                    catch (Exception var7_7) {
                        var7_7.printStackTrace();
                    }
                    finally {
                        Capture.access$200(Capture.this).unlock();
                    }
                } else {
                    var7_8 = var6_6.asIntBuffer();
                    if (Capture.this.copyPixels == null) {
                        Capture.this.copyPixels = new int[Capture.this.sourceWidth * Capture.this.sourceHeight];
                    }
                    try {
                        var7_8.get(Capture.this.copyPixels, 0, Capture.this.width * Capture.this.height);
                        if (Capture.this.capturing) {
                            Capture.access$300(Capture.this);
                        }
                    }
                    finally {
                        Capture.access$200(Capture.this).unlock();
                    }
                }
                var5_5.unmap();
            }
            var2_2.dispose();
            return FlowReturn.OK;
        }
    }

    private class NewPrerollListener
    implements AppSink.NEW_PREROLL {
        private NewPrerollListener() {
        }

        public FlowReturn newPreroll(AppSink appSink) {
            Sample sample = appSink.pullPreroll();
            Structure structure = sample.getCaps().getStructure(0);
            Capture.this.sourceWidth = structure.getInteger("width");
            Capture.this.sourceHeight = structure.getInteger("height");
            Fraction fraction = structure.getFraction("framerate");
            Capture.this.sourceFrameRate = (float)fraction.numerator / (float)fraction.denominator;
            if ((double)Capture.this.frameRate == -1.0) {
                Capture.this.frameRate = Capture.this.sourceFrameRate;
            }
            sample.dispose();
            return FlowReturn.OK;
        }
    }
}

