/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.gstreamer.message;

import java.util.EnumMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.freedesktop.gstreamer.GstObject;
import org.freedesktop.gstreamer.MiniObject;
import org.freedesktop.gstreamer.Structure;
import org.freedesktop.gstreamer.glib.NativeEnum;
import org.freedesktop.gstreamer.glib.NativeObject;
import org.freedesktop.gstreamer.glib.Natives;
import org.freedesktop.gstreamer.lowlevel.GstMessageAPI;
import org.freedesktop.gstreamer.lowlevel.GstMessagePtr;
import org.freedesktop.gstreamer.lowlevel.ReferenceManager;
import org.freedesktop.gstreamer.lowlevel.annotations.HasSubtype;
import org.freedesktop.gstreamer.message.BufferingMessage;
import org.freedesktop.gstreamer.message.DurationChangedMessage;
import org.freedesktop.gstreamer.message.EOSMessage;
import org.freedesktop.gstreamer.message.ErrorMessage;
import org.freedesktop.gstreamer.message.InfoMessage;
import org.freedesktop.gstreamer.message.LatencyMessage;
import org.freedesktop.gstreamer.message.MessageType;
import org.freedesktop.gstreamer.message.NeedContextMessage;
import org.freedesktop.gstreamer.message.SegmentDoneMessage;
import org.freedesktop.gstreamer.message.StateChangedMessage;
import org.freedesktop.gstreamer.message.TagMessage;
import org.freedesktop.gstreamer.message.WarningMessage;

@HasSubtype
public class Message
extends MiniObject {
    public static final String GTYPE_NAME = "GstMessage";
    private static final Map<MessageType, Function<NativeObject.Initializer, Message>> TYPE_MAP = new EnumMap<MessageType, Function<NativeObject.Initializer, Message>>(MessageType.class);
    private final Handle handle;

    Message(NativeObject.Initializer init) {
        this(new Handle(init.ptr.as(GstMessagePtr.class, GstMessagePtr::new), init.ownsHandle), init.needRef);
    }

    Message(Handle handle, boolean needRef) {
        super(handle, needRef);
        this.handle = handle;
    }

    public GstObject getSource() {
        return Natives.objectFor(this.handle.getPointer().getSource(), GstObject.class, true, true);
    }

    public Structure getStructure() {
        return ReferenceManager.addKeepAliveReference(GstMessageAPI.GSTMESSAGE_API.gst_message_get_structure(this), this);
    }

    public MessageType getType() {
        return NativeEnum.fromInt(MessageType.class, MessageType.UNKNOWN, this.handle.getPointer().getMessageType());
    }

    private static Message create(NativeObject.Initializer init) {
        MessageType type = NativeEnum.fromInt(MessageType.class, MessageType.UNKNOWN, init.ptr.as(GstMessagePtr.class, GstMessagePtr::new).getMessageType());
        return TYPE_MAP.getOrDefault(type, Message::new).apply(init);
    }

    static {
        TYPE_MAP.put(MessageType.EOS, EOSMessage::new);
        TYPE_MAP.put(MessageType.ERROR, ErrorMessage::new);
        TYPE_MAP.put(MessageType.BUFFERING, BufferingMessage::new);
        TYPE_MAP.put(MessageType.DURATION_CHANGED, DurationChangedMessage::new);
        TYPE_MAP.put(MessageType.INFO, InfoMessage::new);
        TYPE_MAP.put(MessageType.LATENCY, LatencyMessage::new);
        TYPE_MAP.put(MessageType.SEGMENT_DONE, SegmentDoneMessage::new);
        TYPE_MAP.put(MessageType.STATE_CHANGED, StateChangedMessage::new);
        TYPE_MAP.put(MessageType.TAG, TagMessage::new);
        TYPE_MAP.put(MessageType.WARNING, WarningMessage::new);
        TYPE_MAP.put(MessageType.NEED_CONTEXT, NeedContextMessage::new);
    }

    static class Handle
    extends MiniObject.Handle {
        Handle(GstMessagePtr ptr, boolean ownsHandle) {
            super(ptr, ownsHandle);
        }

        @Override
        protected GstMessagePtr getPointer() {
            return (GstMessagePtr)super.getPointer();
        }
    }

    public static class Types
    implements NativeObject.TypeProvider {
        @Override
        public Stream<NativeObject.TypeRegistration<?>> types() {
            return Stream.of(Natives.registration(Message.class, Message.GTYPE_NAME, x$0 -> Message.create(x$0)));
        }
    }
}

