/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.gstreamer.lowlevel;

import com.sun.jna.Library;
import java.util.HashMap;
import java.util.Map;
import org.freedesktop.gstreamer.lowlevel.GFunctionMapper;
import org.freedesktop.gstreamer.lowlevel.GNative;
import org.freedesktop.gstreamer.lowlevel.GTypeMapper;

public final class GstNative {
    private static final String[] nameFormats = System.getProperty("gstreamer.GstNative.nameFormats", "%s-1.0").split("\\|");
    private static final Map<String, Object> options = new HashMap<String, Object>(){
        {
            this.put("type-mapper", new GTypeMapper());
            this.put("function-mapper", new GFunctionMapper());
        }
    };

    private GstNative() {
    }

    public static <T extends Library> T load(Class<T> interfaceClass) {
        return GstNative.load("gstreamer", interfaceClass);
    }

    public static <T extends Library> T load(String libraryName, Class<T> interfaceClass) {
        for (String format : nameFormats) {
            try {
                return GNative.loadLibrary(String.format(format, libraryName), interfaceClass, options);
            }
            catch (UnsatisfiedLinkError ex) {
            }
        }
        throw new UnsatisfiedLinkError("Could not load library: " + libraryName);
    }
}

