/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.gstreamer;

import com.sun.jna.Pointer;
import java.nio.charset.StandardCharsets;
import org.freedesktop.gstreamer.glib.NativeObject;
import org.freedesktop.gstreamer.lowlevel.GPointer;
import org.freedesktop.gstreamer.lowlevel.GstSDPMessageAPI;

public class SDPMessage
extends NativeObject {
    public static final String GTYPE_NAME = "GstSDPMessage";

    SDPMessage(NativeObject.Initializer init) {
        this(new Handle(init.ptr, init.ownsHandle));
    }

    SDPMessage(Handle handle) {
        super(handle);
    }

    public SDPMessage() {
        this(SDPMessage.initHandle());
    }

    @Override
    public String toString() {
        return GstSDPMessageAPI.GSTSDPMESSAGE_API.gst_sdp_message_as_text(this);
    }

    public void parseBuffer(String sdpString) {
        byte[] data = sdpString.getBytes(StandardCharsets.US_ASCII);
        int length = sdpString.length();
        GstSDPMessageAPI.GSTSDPMESSAGE_API.gst_sdp_message_parse_buffer(data, length, this);
    }

    private static Handle initHandle() {
        Pointer[] ptr = new Pointer[1];
        GstSDPMessageAPI.GSTSDPMESSAGE_API.gst_sdp_message_new(ptr);
        return new Handle(new GPointer(ptr[0]), true);
    }

    private static final class Handle
    extends NativeObject.Handle {
        public Handle(GPointer ptr, boolean ownsHandle) {
            super(ptr, ownsHandle);
        }

        @Override
        protected void disposeNativeHandle(GPointer ptr) {
            GstSDPMessageAPI.GSTSDPMESSAGE_API.gst_sdp_message_free(ptr.getPointer());
        }
    }
}

