/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.gstreamer;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.freedesktop.gstreamer.GstObject;
import org.freedesktop.gstreamer.Plugin;
import org.freedesktop.gstreamer.PluginFeature;
import org.freedesktop.gstreamer.glib.NativeObject;
import org.freedesktop.gstreamer.glib.Natives;
import org.freedesktop.gstreamer.lowlevel.GlibAPI;
import org.freedesktop.gstreamer.lowlevel.GstPluginAPI;
import org.freedesktop.gstreamer.lowlevel.GstPluginFeatureAPI;
import org.freedesktop.gstreamer.lowlevel.GstRegistryAPI;

public class Registry
extends GstObject {
    public static final String GTYPE_NAME = "GstRegistry";

    Registry(NativeObject.Initializer init) {
        super(init);
    }

    public Plugin findPlugin(String name) {
        return GstRegistryAPI.GSTREGISTRY_API.gst_registry_find_plugin(this, name);
    }

    public boolean addPlugin(Plugin plugin) {
        return GstRegistryAPI.GSTREGISTRY_API.gst_registry_add_plugin(this, plugin);
    }

    public void removePlugin(Plugin plugin) {
        GstRegistryAPI.GSTREGISTRY_API.gst_registry_remove_plugin(this, plugin);
    }

    public PluginFeature lookupFeature(String name) {
        return GstRegistryAPI.GSTREGISTRY_API.gst_registry_lookup_feature(this, name);
    }

    public List<Plugin> getPluginList() {
        GlibAPI.GList glist = GstRegistryAPI.GSTREGISTRY_API.gst_registry_get_plugin_list(this);
        List<Plugin> list = this.objectList(glist, Plugin.class);
        GstPluginAPI.GSTPLUGIN_API.gst_plugin_list_free(glist);
        return list;
    }

    public List<Plugin> getPluginList(PluginFilter filter) {
        return this.getPluginList().stream().filter(filter::accept).collect(Collectors.toList());
    }

    public List<PluginFeature> getPluginFeatureListByPlugin(String name) {
        GlibAPI.GList glist = GstRegistryAPI.GSTREGISTRY_API.gst_registry_get_feature_list_by_plugin(this, name);
        List<PluginFeature> list = this.objectList(glist, PluginFeature.class);
        GstPluginFeatureAPI.GSTPLUGINFEATURE_API.gst_plugin_feature_list_free(glist);
        return list;
    }

    public boolean scanPath(String path) {
        return GstRegistryAPI.GSTREGISTRY_API.gst_registry_scan_path(this, path);
    }

    private <T extends GstObject> List<T> objectList(GlibAPI.GList glist, Class<T> objectClass) {
        ArrayList<T> list = new ArrayList<T>();
        for (GlibAPI.GList next = glist; next != null; next = next.next()) {
            if (next.data == null) continue;
            list.add(Natives.objectFor(next.data, objectClass, true, true));
        }
        return list;
    }

    public static Registry get() {
        return Natives.objectFor(GstRegistryAPI.GSTREGISTRY_API.gst_registry_get(), Registry.class, false, false);
    }

    public static interface PluginFilter {
        public boolean accept(Plugin var1);
    }
}

