/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.gstreamer;

import org.freedesktop.gstreamer.ClockID;
import org.freedesktop.gstreamer.GstObject;
import org.freedesktop.gstreamer.glib.NativeObject;
import org.freedesktop.gstreamer.lowlevel.GstClockAPI;

public class Clock
extends GstObject {
    public static final String GTYPE_NAME = "GstClock";

    @Deprecated
    public Clock(NativeObject.Initializer init) {
        super(init);
    }

    public long setResolution(long resolution) {
        return GstClockAPI.GSTCLOCK_API.gst_clock_set_resolution(this, resolution);
    }

    public long getResolution() {
        return GstClockAPI.GSTCLOCK_API.gst_clock_get_resolution(this);
    }

    public long getTime() {
        return GstClockAPI.GSTCLOCK_API.gst_clock_get_time(this);
    }

    public long getInternalTime() {
        return GstClockAPI.GSTCLOCK_API.gst_clock_get_internal_time(this);
    }

    public Clock getMaster() {
        return GstClockAPI.GSTCLOCK_API.gst_clock_get_master(this);
    }

    public boolean setMaster(Clock master) {
        return GstClockAPI.GSTCLOCK_API.gst_clock_set_master(this, master);
    }

    @Deprecated
    public void getCalibration(long internal, long external, long rateNumerator, long rateDenominator) {
        GstClockAPI.GSTCLOCK_API.gst_clock_set_calibration(this, internal, external, rateNumerator, rateDenominator);
    }

    public Calibration getCalibration() {
        long[] internalPtr = new long[1];
        long[] externalPtr = new long[1];
        long[] rateNumPtr = new long[1];
        long[] rateDenomPtr = new long[1];
        GstClockAPI.GSTCLOCK_API.gst_clock_get_calibration(this, internalPtr, externalPtr, rateNumPtr, rateDenomPtr);
        return new Calibration(internalPtr[0], externalPtr[0], rateNumPtr[0], rateDenomPtr[0]);
    }

    public void setCalibration(long internal, long external, long rateNumerator, long rateDenominator) {
        GstClockAPI.GSTCLOCK_API.gst_clock_set_calibration(this, internal, external, rateNumerator, rateDenominator);
    }

    public ClockID newSingleShotID(long time) {
        return GstClockAPI.GSTCLOCK_API.gst_clock_new_single_shot_id(this, time);
    }

    public ClockID newPeriodicID(long startTime, long interval) {
        return GstClockAPI.GSTCLOCK_API.gst_clock_new_periodic_id(this, startTime, interval);
    }

    public static final class Calibration {
        private final long internal;
        private final long external;
        private final long rateNum;
        private final long rateDenom;

        private Calibration(long internal, long external, long rateNum, long rateDenom) {
            this.internal = internal;
            this.external = external;
            this.rateNum = rateNum;
            this.rateDenom = rateDenom;
        }

        public long internal() {
            return this.internal;
        }

        public long external() {
            return this.external;
        }

        public long rateNum() {
            return this.rateNum;
        }

        public long rateDenom() {
            return this.rateDenom;
        }

        public int hashCode() {
            int hash = 7;
            hash = 59 * hash + (int)(this.internal ^ this.internal >>> 32);
            hash = 59 * hash + (int)(this.external ^ this.external >>> 32);
            hash = 59 * hash + (int)(this.rateNum ^ this.rateNum >>> 32);
            hash = 59 * hash + (int)(this.rateDenom ^ this.rateDenom >>> 32);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Calibration other = (Calibration)obj;
            if (this.internal != other.internal) {
                return false;
            }
            if (this.external != other.external) {
                return false;
            }
            if (this.rateNum != other.rateNum) {
                return false;
            }
            return this.rateDenom == other.rateDenom;
        }

        public String toString() {
            return "Calibration{internal=" + this.internal + ", external=" + this.external + ", rateNum=" + this.rateNum + ", rateDenom=" + this.rateDenom + '}';
        }
    }
}

