/*
 * Decompiled with CFR 0.152.
 */
import controlP5.Button;
import controlP5.ControlP5;
import controlP5.Slider;
import controlP5.Textfield;
import controlP5.Toggle;
import java.io.File;
import java.util.ArrayList;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PVector;
import processing.video.Movie;

public class frufru_generator_104
extends PApplet {
    ControlP5 cp5;
    PGraphics textLayer;
    PGraphics pointsLayer;
    PImage selectedImage;
    Movie video;
    ArrayList<PVector> points = new ArrayList();
    ArrayList<PVector[]> curves = new ArrayList();
    PFont customFont;
    PFont defaultFont;
    String text = "FRU";
    float sampleRate = 0.05f;
    int fontSize = 600;
    float curveLength = 20.0f;
    float curveAmp = 22.0f;
    float numPoints = 10000.0f;
    boolean typoChanged = false;
    boolean useImage = false;
    boolean useVideo = false;
    boolean isSelectingImage = false;
    boolean curvesChanged = false;
    boolean alwaysUpdate = false;
    boolean exportingPDFMulti = false;
    boolean exportingPNGMulti = false;
    int multiFrameCounter = 0;
    String multiPDFDir = "";
    String multiPNGDir = "";

    public void preload() {
        this.customFont = this.defaultFont = this.createFont("FreeSans.ttf", this.fontSize);
        this.surfaceSettings();
    }

    public void surfaceSettings() {
        this.surface.setLocation(0, 0);
        this.surface.setTitle("FRUFRU MAKER");
    }

    public void setup() {
        File exportDir = new File(this.sketchPath("_RENDUS"));
        if (!exportDir.exists()) {
            exportDir.mkdirs();
        }
        this.preload();
        this.createGUI();
        this.textLayer = this.createGraphics(this.width, this.height);
        this.pointsLayer = this.createGraphics(this.width, this.height);
        this.drawSource();
        this.generatePointsAndCurves();
    }

    public void draw() {
        String fileName;
        if (this.typoChanged) {
            this.typoChanged = false;
            this.generatePointsAndCurves();
        }
        this.background(240);
        if (this.alwaysUpdate && this.frameCount % 3 == 0) {
            this.generatePointsAndCurves();
        }
        if (this.useVideo && this.frameCount % 3 == 0) {
            this.generatePointsAndCurves();
        }
        this.displayCurves();
        this.image((PImage)this.pointsLayer, 0.0f, 0.0f);
        this.drawThumbnail();
        if (this.exportingPDFMulti) {
            fileName = String.valueOf(this.multiPDFDir) + "/" + frufru_generator_104.nf((int)this.multiFrameCounter, (int)4) + ".pdf";
            PGraphics pdf = this.createGraphics(this.width, this.height, "processing.pdf.PGraphicsPDF", fileName);
            pdf.beginDraw();
            pdf.stroke(0);
            pdf.noFill();
            for (PVector[] curve : this.curves) {
                pdf.bezier(curve[0].x, curve[0].y, curve[1].x, curve[1].y, curve[2].x, curve[2].y, curve[3].x, curve[3].y);
            }
            pdf.endDraw();
            pdf.dispose();
            frufru_generator_104.println((String)("PDF export\u00e9 : " + fileName));
            ++this.multiFrameCounter;
        }
        if (this.exportingPNGMulti) {
            fileName = String.valueOf(this.multiPNGDir) + "/" + frufru_generator_104.nf((int)this.multiFrameCounter, (int)4) + ".png";
            this.saveFrame(fileName);
            frufru_generator_104.println((String)("PNG export\u00e9 : " + fileName));
            ++this.multiFrameCounter;
        }
    }

    public void drawThumbnail() {
        this.push();
        this.textAlign(37);
        this.translate(this.width - this.textLayer.width / 4 - 10, 10.0f);
        this.image((PImage)this.textLayer, 0.0f, 0.0f, this.textLayer.width / 4, this.textLayer.height / 4);
        this.noFill();
        this.stroke(150);
        this.rect(0.0f, 0.0f, this.textLayer.width / 4, this.textLayer.height / 4);
        this.fill(150);
        this.noStroke();
        this.text("Source Layer", 10.0f, 20.0f);
        this.pop();
    }

    public void createGUI() {
        this.cp5 = new ControlP5((PApplet)this);
        int labelSize = 12;
        int sliderWidth = 200;
        int sliderHeight = 20;
        int posX = 20;
        int posY = 20;
        int step = 30;
        this.cp5.setColorActive(this.color(180, 0, 250)).setColorBackground(this.color(180)).setColorForeground(this.color(100)).setColorCaptionLabel(this.color(0)).setColorValueLabel(this.color(0));
        ((Textfield)((Textfield)this.cp5.addTextfield("inputText").setPosition((float)posX, (float)posY)).setSize(sliderWidth, sliderHeight * 2).setAutoClear(false).setLabel("Enter text")).getCaptionLabel().setSize(labelSize);
        this.createButton("loadmyFont", posX, posY += 60, sliderWidth, "Load Font", labelSize);
        this.createButton("loadImage", posX, posY += 40, sliderWidth, "Load Image", labelSize);
        this.createButton("loadVideo", posX, posY += 40, sliderWidth, "Load Video", labelSize);
        this.createSlider("sampleRate", posX, posY += step + 30, sliderWidth, sliderHeight, 0.0f, 1.0f, this.sampleRate, "Sample Rate", labelSize);
        this.createSlider("fontSize", posX, posY += step, sliderWidth, sliderHeight, 1.0f, 1000.0f, this.fontSize, "Font Size", labelSize);
        this.createSlider("curveLength", posX, posY += step, sliderWidth, sliderHeight, 1.0f, 200.0f, this.curveLength, "Curve Length", labelSize);
        this.createSlider("curveAmp", posX, posY += step, sliderWidth, sliderHeight, 1.0f, 100.0f, this.curveAmp, "Curve Amplitude", labelSize);
        this.createSlider("numPoints", posX, posY += step, sliderWidth, sliderHeight, 1000.0f, 100000.0f, this.numPoints, "Number of Points", labelSize);
        this.createButton("exportPDF", posX, posY += 40, sliderWidth, "Export to PDF", labelSize);
        this.createButton("startExportPDFMulti", posX, posY += 40, sliderWidth, "Start Multi-frame PDF", labelSize);
        this.createButton("stopExportPDFMulti", posX, posY += 40, sliderWidth, "Stop Multi-frame PDF", labelSize);
        this.createButton("exportPNG", posX, posY += 40, sliderWidth, "Export Single Frame PNG", labelSize);
        this.createButton("startExportPNGMulti", posX, posY += 40, sliderWidth, "Start Multi-frame PNG", labelSize);
        this.createButton("stopExportPNGMulti", posX, posY += 40, sliderWidth, "Stop Multi-frame PNG", labelSize);
        this.createToggle("alwaysUpdate", posX, posY += 40, "Update each frame", this.alwaysUpdate);
    }

    public void createButton(String name, int x, int y, int width, String label, int labelSize) {
        ((Button)((Button)((Button)this.cp5.addButton(name).setPosition((float)x, (float)y)).setSize(width, 30)).setLabel(label)).getCaptionLabel().setSize(labelSize);
    }

    public void createSlider(String name, int x, int y, int w, int h, float min, float max, float val, String label, int labelSize) {
        ((Slider)((Slider)this.cp5.addSlider(name).setPosition((float)x, (float)y)).setSize(w, h).setRange(min, max).setValue(val).setLabel(label)).getCaptionLabel().setSize(labelSize);
        this.cp5.getController(name).addListener(event -> {
            boolean bl = this.typoChanged = true;
        });
    }

    public void createToggle(String name, int x, int y, String label, boolean def) {
        ((Toggle)((Toggle)this.cp5.addToggle(name).setPosition((float)x, (float)y)).setSize(20, 20)).setValue(def).setMode(100).setLabel(label);
    }

    public void inputText(String theText) {
        this.text = theText;
        this.useVideo = false;
        this.useImage = false;
        this.typoChanged = true;
    }

    public void loadmyFont() {
        this.selectInput("Select a font file (.ttf, .otf):", "fileSelected");
    }

    public void loadImage() {
        if (!this.isSelectingImage) {
            this.isSelectingImage = true;
            this.selectInput("Select an image file:", "imageSelected");
        }
    }

    public void loadVideo() {
        this.selectInput("Select a video file:", "videoSelected");
    }

    public void videoSelected(File selection) {
        if (selection != null) {
            this.video = new Movie((PApplet)this, selection.getAbsolutePath());
            this.video.loop();
            this.useVideo = true;
            this.useImage = false;
            this.typoChanged = true;
        }
    }

    public void fileSelected(File selection) {
        if (selection != null) {
            this.customFont = this.createFont(selection.getAbsolutePath(), this.fontSize);
            this.typoChanged = true;
        }
    }

    public void imageSelected(File selection) {
        this.isSelectingImage = false;
        if (selection != null) {
            this.selectedImage = this.loadImage(selection.getAbsolutePath());
            this.useImage = this.selectedImage != null;
            this.useVideo = false;
            this.typoChanged = true;
        }
    }

    public void drawSource() {
        this.textLayer.beginDraw();
        this.textLayer.background(255);
        this.textLayer.imageMode(3);
        if (this.useVideo && this.video != null) {
            this.textLayer.image((PImage)this.video, (float)(this.width / 2), (float)(this.height / 2));
        } else if (this.useImage && this.selectedImage != null) {
            this.textLayer.image(this.selectedImage, (float)(this.width / 2), (float)(this.height / 2), (float)this.width, (float)this.height);
        } else {
            this.textLayer.fill(0);
            this.textLayer.textFont(this.customFont);
            this.textLayer.textSize((float)this.fontSize);
            this.textLayer.textAlign(3, 3);
            this.textLayer.text(this.text, (float)(this.width / 2), (float)(this.height / 2));
        }
        this.textLayer.endDraw();
    }

    public void generatePointsAndCurves() {
        this.drawSource();
        this.points.clear();
        this.curves.clear();
        this.textLayer.loadPixels();
        int numPointsInt = PApplet.parseInt((float)this.numPoints);
        int i = 0;
        while (i < numPointsInt) {
            int x = PApplet.parseInt((float)this.random(this.width));
            int y = PApplet.parseInt((float)this.random(this.height));
            int index = x + y * this.width;
            float b = this.brightness(this.textLayer.pixels[index]);
            if (this.random(1.0f) < frufru_generator_104.map((float)b, (float)0.0f, (float)200.0f, (float)this.sampleRate, (float)0.0f)) {
                this.points.add(new PVector((float)x, (float)y));
                this.curves.add(this.generateCurve(x, y));
            }
            ++i;
        }
        this.curvesChanged = true;
    }

    public PVector[] generateCurve(float x, float y) {
        float endX = x + this.random(-this.curveLength, this.curveLength);
        float endY = y + this.random(-this.curveLength, this.curveLength);
        return new PVector[]{new PVector(x, y), new PVector(x + this.random(-this.curveAmp, this.curveAmp), y + this.random(-this.curveAmp, this.curveAmp)), new PVector(endX + this.random(-this.curveAmp, this.curveAmp), endY + this.random(-this.curveAmp, this.curveAmp)), new PVector(endX, endY)};
    }

    public void displayCurves() {
        if (!this.curvesChanged) {
            return;
        }
        this.pointsLayer.beginDraw();
        this.pointsLayer.background(240);
        this.pointsLayer.stroke(0);
        this.pointsLayer.noFill();
        for (PVector[] curve : this.curves) {
            this.pointsLayer.bezier(curve[0].x, curve[0].y, curve[1].x, curve[1].y, curve[2].x, curve[2].y, curve[3].x, curve[3].y);
        }
        this.pointsLayer.endDraw();
        this.curvesChanged = false;
    }

    public void exportPDF() {
        String fileName = "_RENDUS/" + frufru_generator_104.year() + "-" + frufru_generator_104.nf((int)frufru_generator_104.month(), (int)2) + "-" + frufru_generator_104.nf((int)frufru_generator_104.day(), (int)2) + "_" + frufru_generator_104.nf((int)frufru_generator_104.hour(), (int)2) + "-" + frufru_generator_104.nf((int)frufru_generator_104.minute(), (int)2) + "-" + frufru_generator_104.nf((int)frufru_generator_104.second(), (int)2) + "-" + this.text + ".pdf";
        PGraphics pdf = this.createGraphics(this.width, this.height, "processing.pdf.PGraphicsPDF", fileName);
        pdf.beginDraw();
        pdf.stroke(0);
        pdf.noFill();
        for (PVector[] curve : this.curves) {
            pdf.bezier(curve[0].x, curve[0].y, curve[1].x, curve[1].y, curve[2].x, curve[2].y, curve[3].x, curve[3].y);
        }
        pdf.endDraw();
        pdf.dispose();
        frufru_generator_104.println((String)("PDF single export\u00e9 : " + fileName));
    }

    public void startExportPDFMulti() {
        this.multiPDFDir = "_RENDUS/export_pdf_" + frufru_generator_104.year() + "-" + frufru_generator_104.nf((int)frufru_generator_104.month(), (int)2) + "-" + frufru_generator_104.nf((int)frufru_generator_104.day(), (int)2) + "_" + frufru_generator_104.nf((int)frufru_generator_104.hour(), (int)2) + "-" + frufru_generator_104.nf((int)frufru_generator_104.minute(), (int)2) + "-" + frufru_generator_104.nf((int)frufru_generator_104.second(), (int)2);
        File dir = new File(this.multiPDFDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.exportingPDFMulti = true;
        this.multiFrameCounter = 0;
        frufru_generator_104.println((String)("Export multi-frame PDF d\u00e9marr\u00e9 dans le dossier : " + this.multiPDFDir));
    }

    public void stopExportPDFMulti() {
        this.exportingPDFMulti = false;
        frufru_generator_104.println((String)"Export multi-frame PDF arr\u00eat\u00e9.");
    }

    public void exportPNG() {
        String fileName = "_RENDUS/export_" + frufru_generator_104.year() + "-" + frufru_generator_104.nf((int)frufru_generator_104.month(), (int)2) + "-" + frufru_generator_104.nf((int)frufru_generator_104.day(), (int)2) + "_" + frufru_generator_104.nf((int)frufru_generator_104.hour(), (int)2) + "-" + frufru_generator_104.nf((int)frufru_generator_104.minute(), (int)2) + "-" + frufru_generator_104.nf((int)frufru_generator_104.second(), (int)2) + ".png";
        this.saveFrame(fileName);
        frufru_generator_104.println((String)("PNG single export\u00e9 : " + fileName));
    }

    public void startExportPNGMulti() {
        this.multiPNGDir = "_RENDUS/export_png_" + frufru_generator_104.year() + "-" + frufru_generator_104.nf((int)frufru_generator_104.month(), (int)2) + "-" + frufru_generator_104.nf((int)frufru_generator_104.day(), (int)2) + "_" + frufru_generator_104.nf((int)frufru_generator_104.hour(), (int)2) + "-" + frufru_generator_104.nf((int)frufru_generator_104.minute(), (int)2) + "-" + frufru_generator_104.nf((int)frufru_generator_104.second(), (int)2);
        File dir = new File(this.multiPNGDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.exportingPNGMulti = true;
        this.multiFrameCounter = 0;
        frufru_generator_104.println((String)("Export multi-frame PNG d\u00e9marr\u00e9 dans le dossier : " + this.multiPNGDir));
    }

    public void stopExportPNGMulti() {
        this.exportingPNGMulti = false;
        frufru_generator_104.println((String)"Export multi-frame PNG arr\u00eat\u00e9.");
    }

    public void movieEvent(Movie m) {
        m.read();
    }

    public void settings() {
        this.size(1800, 1160);
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"--full-screen", "--bgcolor=#666666", "--stop-color=#cccccc", "frufru_generator_104"};
        if (passedArgs != null) {
            PApplet.main((String[])frufru_generator_104.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }
}

